%comparing expReplay rev buf vesus reading samples in order

d=5;%dimension
sig=1;%noise variance
rho=0.9;%operator norm of A^*
U=rand_ortho(d);
A_bimod=U'*diag([0.9*ones(1,ceil(d/2)),0.3*ones(1,d-ceil(d/2))])*U;
A_true=A_bimod;%A^* to generate VAR model
A0=zeros(d,d);%initializatio for SGD-RER
X0=zeros(d,1);%initialization fot VAR model
B=100;%processed buffer size
u=10;%gap between buffers
T=1e7;
T1=floor(T/(B+u));%total number of buffers
T_expReplay=T1*(B+u);%actual samples generated
range_T_expReplay=(1:1:T1)*(B+u);
range_T1_expReplay=1:1:T1;

n_samples_norm_est=floor(2*log(T_expReplay));%#samples for R estimation
tavg_start=floor(log(T_expReplay));%buffer index where to start tail averaging,
%don't add n_samples_norm_est to tavg_start, since we index buffer from t=1
T1_eff=T1-(floor(n_samples_norm_est/(B+u))+1);%effective #of buffers to run sgd on
[op_norm_buf_avg_ER_revBuf,op_norm_buf_tavg_ER_revBuf,...
    op_norm_buf_avg_ER_randBuf,op_norm_buf_tavg_ER_randBuf,...
    op_norm_avg_ER_noBuf,op_norm_tavg_ER_noBuf,op_norm_ols]=...
    AR_algos_compare_neurips(A0,X0,T1,d,sig,A_true,B,u,T1_eff,n_samples_norm_est,tavg_start);



set(groot, 'defaultTextInterpreter','latex');
figure;
subplot(1,2,1);
loglog(range_T1_expReplay,[op_norm_buf_avg_ER_revBuf;op_norm_buf_avg_ER_randBuf;op_norm_avg_ER_noBuf;op_norm_ols]);
title({['Full-Avg: error vs buffer $t$, RandBiMod $A^*$, $\rho=',num2str(rho),' $, dimension $d=',num2str(d),'$, step size $\gamma=0.5 \max(1-\rho^2,1/T)/(\sigma^2 d \log T)$, $\sigma=',num2str(sig),'$, buffer size $B+u=',num2str(B),'+',num2str(u),'$']});
xlabel('Buffer index $t$');
ylabel('$||\hat A_{0,t}-A^*||$');
legend({'Rev Buf','Rand Buf','No Buffer','OLS'},'Interpreter','latex');

subplot(1,2,2);
loglog(range_T1_expReplay,[op_norm_buf_tavg_ER_revBuf;op_norm_buf_tavg_ER_randBuf;op_norm_tavg_ER_noBuf;op_norm_ols]);
title({['$t-\log T$ Tail-Avg: error vs buffer $t$, RandBiMod $A^*$, $\rho=',num2str(rho),'$, dimension $d=',num2str(d),'$, step size $\gamma=0.5 \max(1-\rho^2,1/T)/(\sigma^2 d \log T)$, $\sigma=',num2str(sig),'$, buffer size $B+u=',num2str(B),'+',num2str(u),'$']});
xlabel('Buffer index $t$');
ylabel('$||\hat A_{\log T,t}-A^*||$');
legend({'Rev Buf','Rand Buf','No Buffer','OLS'},'Interpreter','latex');
