# To replicate the experiments in the paper:

## Step 1: Environment and Prerequisites
Run the following commands to clone this repo and create the Conda environment:

```
conda env create -f environment.yml
conda activate expl_dist_shift
```

## Step 2: Running Experiments
To reproduce the experiments in the paper which involve training grids of models and then generating explanations for them, use `sweep.py` as follows:

```
python -m sweep launch \
    --experiment {experiment_name} \
    --output_dir {output_root} \
    --command_launcher {launcher} 
```

where:
- `experiment_name` corresponds to experiments defined as classes in `experiments.py`
- `output_root` is a directory where experimental results will be stored.
- `launcher` is a string corresponding to a launcher defined in scripts/launchers.py (i.e. `slurm` or `local`).


The `train_model` experiment should be ran first. The remaining experiments can be ran in any order.

Alternatively, a single explanation can also be generated by calling `explain.py` with the appropriate arguments.

The experimental confirmation for the synthetic derivation can be found in `notebooks/derivation_synthetic.ipynb`.