from expl_dist_shift.data import synthetic
from expl_dist_shift.data import celebA
from expl_dist_shift.data import wildsdata
from expl_dist_shift.data import eicu

def select(hparams, device):
    if hparams['dataset'] == 'synthetic':
        return synthetic.BackdoorSpurious(hparams)
    elif hparams['dataset'] == 'waterbirds':
        return wildsdata.WildsDataset('waterbirds', hparams, device)
    elif hparams['dataset'] == 'celebA':
        return celebA.CelebA(hparams, device)
    elif hparams['dataset'] == 'metashift':
        return wildsdata.WildsDataset('metashift', hparams, device)
    elif hparams['dataset'] == 'eicu':
        return eicu.eICU(hparams)
    else:
        raise NotImplementedError(hparams['dataset'])