
import numpy as np
from sklearn.linear_model import LogisticRegression, Ridge
from sklearn.model_selection import GridSearchCV
from xgboost.sklearn import XGBClassifier, XGBRegressor
from sklearn.pipeline import Pipeline
from sklearn.preprocessing import StandardScaler
from sklearn.base import BaseEstimator, TransformerMixin

def select(model_type, task = 'classification'):
    if model_type == 'xgb' and task == 'classification':
        return GridSearchCV(
            estimator = XGBClassifier(random_state = 42, n_jobs = -1),
            param_grid = {'max_depth': [1, 2, 3, 4, 5]},
            scoring = 'roc_auc_ovr',
            cv = 3,
            refit = True
        )
    elif model_type == 'xgb' and task == 'regression':
        return GridSearchCV(
            estimator = XGBRegressor(random_state = 42, n_jobs = -1, objective ='reg:squarederror'),
            param_grid = {'max_depth': [1, 2, 3, 4, 5]},
            scoring = 'neg_mean_absolute_error',
            cv = 3,
            refit = True
        )
    elif model_type == 'lr' and task == 'classification':
        return GridSearchCV(
            estimator = Pipeline([
                ('scaler', StandardScaler()),
                ('model', LogisticRegression(random_state = 42))
            ]),
            param_grid = {'model__C': np.logspace(-4, 1, 20)},
            scoring = 'roc_auc_ovr',
            cv = 3,
            refit = True,
            n_jobs = -1
        )
    elif model_type == 'lr' and task == 'regression':
        return GridSearchCV(
            estimator = Pipeline([
                ('scaler', StandardScaler()),
                ('model', Ridge(random_state = 42))
            ]),
            param_grid = {'model__alpha': np.logspace(0, 4, 20)},
            scoring = 'neg_mean_absolute_error',
            cv = 3,
            refit = True,
            n_jobs = -1
        )
    else:
        raise NotImplementedError(model_type)