## Influence-based Reasoning Attribution (Infra)

This is the official implementation of **Influence-based Reasoning Attribution (Infra)**.

The codebase includes:

* **`kronfluence/`**: Implementation of the influence score using EK-FAC (Kronecker-Factored Approximate Curvature).
* **`examples/`**: Adaptations of Infra to reasoning-based supervised fine-tuning (SFT) scenarios.

---

### 🔍 Compute Influence Scores

You can compute instance-, sequence-, or token-level influence scores in two main steps:

---

#### **1. Fit EK-FAC Factors**

```bash
torchrun --standalone --nnodes=1 --nproc-per-node=8 fit_factors_bs.py \
    --factors_name bs17k \
    --factor_batch_size 1
```

This step fits the curvature factors required to compute influence scores.

---

#### **2. Compute Influence Scores**

```bash
torchrun --standalone --nnodes=1 --nproc-per-node=8 compute_scores_bs.py \
    --factors_name bs17k \
    --scores_name <your_output_name> \
    --train_batch_size 1 \
    --aggregate_query_gradients
```

This computes the desired influence scores using the precomputed factors.
