# Agent Environments

This project contains the agentenv python package and the integrated environments.

## Setup

``` sh
cd ./AgentEnvironments

cd agentenv
conda env create -n agentenv -f environment.yml
conda activate agentenv
pip install -e .
```

Depending on which environments you want to use, `cd` into the corresponding `agentenv-*` folder and follow the `README.md` inside.


## Training
For **AGENTEVOL** method, follow ``./AgentEnvironments/agentenv/examples/train_agent_evol_multi_task.sh``.

For **BC** method, follow ``./AgentEnvironments/agentenv/examples/train_sft_multi_task.sh``.


## Evaluation
Evaluating distributed tasks (such as webshop, alfworld), use ``./AgentEnvironments/agentenv/examples/distributed_eval_scripts/distributed_eval_task.py``.

Evaluating single process tasks (such as tool-weather, webarena), use ``./AgentEnvironments/agentenv/examples/base_eval_script.sh``.

## Data
Train and test data for **AGENTGYM** is in ``./AgentEnvironments/data`` folder.
