import random
import json
from agentenv_textcraft import CraftingTree
from agentenv_textcraft import item_id_to_str

seed = 42

tree = CraftingTree(minecraft_dir="agentenv_textcraft/")
random.seed(seed)

query = []

with open("train.json", "r") as f:
    content = f.read()
    goals = json.loads(content)

for goal in goals:
    # goal = "minecraft:dark_oak_sign"
    recipes_set = set()
    distractor_set = set()
    max_distractor = 10
    recipes, distractors = tree.create_recipe_set(goal)
    for recipe in recipes:
        recipes_set.add(recipe.recipe_str)
    for distractor in distractors:
        if distractor.recipe_str not in recipes_set:
            distractor_set.add(distractor.recipe_str)

    recipes_list = list(recipes_set) + random.sample(list(distractor_set),
                                                        min(len(distractor_set), max_distractor))
    random.shuffle(recipes_list)
    query.append({"Crafting commands": "\n".join(recipes_list), "Goal": goal})

with open("train_query.json", "w") as f:
    json.dump(query, f, indent=4)