from torch.utils.data import Dataset

class DictDatasetBase(Dataset):
    """データセットの基底クラス"""
    def __init__(self, input_texts, target_texts, **kwargs):
        self.input_texts = input_texts
        self.target_texts = target_texts
        self.setup(**kwargs)
    
    def setup(self, **kwargs):
        """データセット固有の初期化処理"""
        raise NotImplementedError

class DataCollatorBase:
    """データコレーターの基底クラス"""
    def __init__(self, **kwargs):
        self.setup(**kwargs)
    
    def setup(self, **kwargs):
        """コレーター固有の初期化処理"""
        raise NotImplementedError
    
    def __call__(self, batch):
        raise NotImplementedError