#!/bin/bash

set -x
set -e


export https_proxy=http://10.15.82.10:7899

# read from args
data_dir=$1
prediction_dir=$2

export CUDA_VISIBLE_DEVICES=$3

# if dailylifeapis in $data_dir, then add --ignore_tool_type true arguement to evaluate.py
if [[ $data_dir == *"dailylifeapis"* ]]; then
    ignore_tool_type=true
else
    ignore_tool_type=false
fi

for file in $data_dir/$prediction_dir/*.json
do
    llm=$(basename $file .json)
    metrics=$(echo $prediction_dir | sed 's/predictions/metrics/g')
    metrics=${metrics}_alignment_human
    if [ -f $data_dir/$metrics/${llm}.json ] && [ -s $data_dir/$metrics/${llm}.log ];
    then
        continue
    fi
    echo $llm
    python evaluate.py --data_dir $data_dir --prediction_dir $prediction_dir --llm $llm --splits all --n_tools all --mode add --ignore_tool_type $ignore_tool_type -m all --alignment human
done