import numpy as np
import lib as lib
import collections
import matplotlib.pyplot as plt

def L(t, a):
	if a == 0:
		return 0.5
	elif a == 1:
		return 0
	
a_dagger = 0

Ts = [10**3, 10**4, 10**5, 10**6]

eps = 0.25

alpha = 0.5

attacker = lib.attacker(a_dagger, alpha, eps)

Ntrial = 1

save_dir = 'results/results.txt'
f = open(save_dir, 'w')

attack_costs = {}
N_dagger = {}

f.write(",".join(str(x) for x in Ts) + "\n")
f.write(str(Ntrial) + "\n")
for trial in range(Ntrial):
	print(trial)
	attack_costs[trial] = [0 for _ in range(len(Ts))]
	N_dagger[trial] = [0 for _ in range(len(Ts))]
	for idx, T in enumerate(Ts):
		print(T)
		Phi = T**(0.9)
		player = lib.EXPRB(2, T, Phi)
		for t in range(1, T+1):
			at = player.select_arm()
			
			if at == a_dagger:
				N_dagger[trial][idx] += 1

			lt = L(t, at)
			lt_poisoned = attacker.HardAttack(lt, at, t)
			delta = lt_poisoned - lt
			attack_costs[trial][idx]+=abs(delta)
			player.update_weight(at, lt_poisoned)

	f.write(",".join(str(x) for x in N_dagger[trial]) + "\n")
	f.write(",".join(str(x) for x in attack_costs[trial]) + "\n")
f.close()