# Task bash files to be called by the overall bash file for all experiments of the specified model type.
# We provide all of the individual bash files per task and model to make individual experiments easy to call.

# OOM prevention
reset_cuda(){
    sleep 10    
}

DEVICE=$1
seed=$2
#############################################################
################ CIFAR10 RANDOM FORGETTING ##################
#############################################################

forget_perc=0.00165 # 100 samples
dataset=Cifar10
n_classes=10
weight_path=checkpoint/ViT/Friday_04_August_2023_14h_09m_55s/ViT-Cifar10-7-best.pth

# Run the Python script
CUDA_VISIBLE_DEVICES=$DEVICE python forget_random_main.py -net ViT -dataset $dataset -classes $n_classes -gpu -method lfssd_tuning -forget_perc $forget_perc -weight_path $weight_path -seed $seed 
reset_cuda
