# Task bash files to be called by the overall bash file for all experiments of the specified model type.
# We provide all of the individual bash files per task and model to make individual experiments easy to call.

reset_cuda(){
    sleep 10    
}

DEVICE=$1
seed=$2
#############################################################
################ CIFAR100 ROCKET FORGETTING #################
#############################################################
declare -a StringArray=("rocket" "mushroom" "baby" "lamp" "sea") # classes to iterate over


dataset=Cifar100
n_classes=100
weight_path=checkpoint/ViT/Friday_04_August_2023_15h_43m_00s/ViT-Cifar100-7-best.pth

for val in "${StringArray[@]}"; do
    forget_class=$val
    CUDA_VISIBLE_DEVICES=$DEVICE python forget_full_class_main.py -net ViT -dataset $dataset -classes $n_classes -gpu -method lfssd_tuning -forget_class $forget_class -weight_path $weight_path -seed $seed
    reset_cuda

done