# This is the main file to run all experiments
# Bash file to run different seeds (corresponding to the value) across all tasks
# Pass the GPU ID with the first parameter (e.g., 0; check via nvidia-smi)

#!/bin/bash
set -e # uncomment to make the script stop when an error occurs; otherwise will ignore
DEVICE=$1

reset_cuda(){
    sleep 10    
}

# TODO: Set the range for the number of seeds you want to run. Value is used as seed
# TODO: Do not forget to set the paths to the model weights in the other bash files (e.g., cifar20_fullclass_exps.sh)
# You might encounter issues with executing this file due to different line endings with Windows and Unix. Use dos2unix "filename" to fix.

# Faces

declare -a StringArray=("1" "10" "20" "30" "40")


dataset=PinsFaceRecognition
n_classes=105
weight_path=checkpoint/ResNet18/Saturday_12_August_2023_10h_50m_04s/ResNet18-PinsFaceRecognition-194-best.pth

seed=42
for val in "${StringArray[@]}"; do
    forget_class=$val
    # Run the Python script
    CUDA_VISIBLE_DEVICES=$DEVICE python forget_full_class_main.py -net ResNet18 -dataset $dataset -classes $n_classes -gpu -method lfssd_tuning -forget_class $forget_class -weight_path $weight_path -seed $seed
    reset_cuda

done

for value in {1..10}
do  
    echo $value
    ./lfssd_cifar10_random_exps.sh $DEVICE $value

done



value=1
./lfssd_cifar20_fullclass_exps.sh $DEVICE $value
./lfssd_cifar100_fullclass_exps.sh $DEVICE $value
./lfssd_cifar20_subclass_exps.sh $DEVICE $value