#!/bin/bash

# Define the search space
decays=(0 1e-2 5e-3 1e-3)
betas=(-1 -0.5 -2)
lrs=(1e-2 5e-3 1e-3)
gnn_layers=(1 2 3 4)
trans_layers=(1 2 3)
graph_weights=(0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0)
dropouts=(0.0 0.1 0.2 0.3 0.4 0.5) #0.6 0.7 0.8 0.9
runs=(1 2 3 4 5)
seeds=(1000 1111 1192 1567 1888 1999 912 1234)
# Initialize best score and settings
# best_score=-1
# # best_wd1=0
# # best_wd2=0
# # best_wd3=0
# # best_lr=0
# best_w=0

# Grid search
# for wd1 in "${decays[@]}"; do
#     for wd2 in "${decays[@]}"; do
#         for wd3 in "${decays[@]}"; do
#             for lr in "${lrs[@]}"; do
#                 echo "Trying: wd1=$wd1, wd2=$wd2, wd3=$wd3, lr=$lr"

#                 # Run the command and capture the test result
#                 result=$(python main.py --task=nc --dataset=cora --model=QGT \
#                     --trans_num_layers=3 --trans_num_heads=1 --epochs=1000 \
#                     --lr=$lr --seed=1234  --patience=500 --step_lr=1000 \
#                     --dropout=0.3 --act=tanh --time_dim=14 --space_dim=2 \
#                     --graph_dropout=0.0 --graph_num_layers=4 --graph_weight=0.8 \
#                     --weight_decay=$wd1 --weight_decay_2=$wd2 --weight_decay_3=$wd3)

#                 # Extract the float score from output
#                 #echo "${RESULT}"
#                 tmp=$(grep "Best test results" ./output/nc/QGT/cora/1234/result.txt)
#                 score=$(echo "$tmp" | grep -oE '[0-9]+\.[0-9]+' | tail -n 1)
#                 # echo "$score"
#                 if [ -z "$score" ]; then
#                     score=-1
#                 fi

#                 # Check if this is the best so far
#                 is_better=$(awk -v s="$score" -v b="$best_score" 'BEGIN {print (s > b) ? 1 : 0}')
#                 if [ "$is_better" -eq 1 ]; then
#                     best_score=$score
#                     best_wd1=$wd1
#                     best_wd2=$wd2
#                     best_wd3=$wd3
#                     best_lr=$lr
#                     echo "✅ New best: $best_score with wd1=$best_wd1, wd2=$best_wd2, wd3=$best_wd3, lr=$best_lr" >> ./output/weight_search_cora_best_result.txt
#                 fi
#             done
#         done
#     done
# done

# # Print the best result
# echo "======================================" >> ./output/weight_search_cora_best_result.txt
# echo "🏆 Best Score: $best_score" >> ./output/weight_search_cora_best_result.txt
# echo "Best hyperparameters: wd1=$best_wd1, wd2=$best_wd2, wd3=$best_wd3, lr=$best_lr" >> ./output/weight_search_cora_best_result.txt

best_score=-1
best_trans_d=-1
best_graph_d=-1

for seed in "${seeds[@]}"; do
    echo "Trying: seed=$seed" >> ./output/weight_search_fb100_best_result.txt
    for run in "${runs[@]}"; do
        # Run the command and capture the test result
        result=$(python main.py --task=nc --dataset=fb100 --model=QGT --trans_num_layers=1 --trans_num_heads=1 \
                --epochs=1000 --lr=0.001 --seed=$seed --patience=1000 --min_epoch=250  --act=tanh --time_dim=15 \
                --space_dim=1  --graph_num_layers=2 --graph_weight=0.9 --weight_decay=5e-12 --weight_decay_2=5e-12 \
                --weight_decay_3=5e-12 --dropout_time=0.4 --dropout_space=0.0 --g_dropout_time=0.4 --g_dropout_space=0.0 \
                --normalize_feats)

        # Extract the float score from output
        #echo "${RESULT}"
        tmp=$(grep "Best test results" ./output/nc/QGT/fb100/$seed/result.txt)
        score=$(echo "$tmp" | grep -oE '[0-9]+\.[0-9]+' | tail -n 1)
        # # echo "$score"
        # if [ -z "$score" ]; then
        #     score=-1
        # fi

        # # Check if this is the best so far
        # is_better=$(awk -v s="$score" -v b="$best_score" 'BEGIN {print (s > b) ? 1 : 0}')
        # if [ "$is_better" -eq 1 ]; then
        #     best_score=$score
        #     best_trans_d=$trans_d
        #     best_graph_d=$graph_d
        echo "✅ Run: $run   Score: $score" >> ./output/weight_search_fb100_best_result.txt
        # fi
    done
done

# # Print the best result
# echo "======================================" >> ./output/weight_search_cora_best_result.txt
# echo "🏆 Best Score: $best_score" >> ./output/weight_search_cora_best_result.txt
# echo "Best hyperparameters: trans_dropout=$best_trans_d , graph_dropout=$best_graph_d" >> ./output/weight_search_cora_best_result.txt
