#To run GCN:

python main.py --task=nc --dataset=cora --model=GCN --nhid=16 --epochs=1000 --lr=0.01 --weight_decay=5e-4 \
  --seed= --using_riemannianAdam=False --act=relu --patience=300 --step_lr=1000 --use_feats

python main.py --task=nc --dataset=citeseer --model=GCN --nhid=16 --epochs=1000 --lr=0.01 --weight_decay=5e-4 \
 --seed= --using_riemannianAdam=False --act=relu --patience=300 --step_lr=1000 --use_feats

python main.py --task=nc --dataset=pubmed --model=GCN --nhid=16 --epochs=1000 --lr=0.01 --weight_decay=5e-4 \
 --seed= --using_riemannianAdam=False --act=relu --patience=300 --step_lr=1000 --use_feats

python main.py --task=nc --dataset=airport --model=GCN --nhid=16 --epochs=1000 --lr=0.01 --weight_decay=5e-4 \
 --seed= --using_riemannianAdam=False --act=relu --patience=300 --step_lr=1000 --use_feats

python main.py --task=nc --dataset=ogbn-arxiv --model=GCN --nhid=16 --epochs=1000 --lr=0.01 --weight_decay=5e-7 \
 --seed= --using_riemannianAdam=False --act=relu --patience=300 --step_lr=1000 --use_feats

python main.py --task=nc --dataset=fb100 --model=GCN --nhid=16 --epochs=1000 --lr=0.01  --weight_decay=5e-7 \
 --seed= --using_riemannianAdam=False --act=relu --patience=300 --step_lr=1000 --use_feats

python main.py --task=nc --dataset=twitch_gamer --model=GCN --nhid=16 --epochs=1000 --lr=0.001  --weight_decay=5e-7 \
 --seed= --using_riemannianAdam=False --act=relu --patience=300 --step_lr=1000 --use_feats

#To run HGCN:

python main.py --task=nc --dataset=cora --model=HGCN --nhid=16 --epochs=1000 --lr=0.01  --weight_decay=5e-4 \
 --seed= --using_riemannianAdam=True --act=relu --patience=300 --step_lr=1000 --use_feats

python main.py --task=nc --dataset=citeseer --model=HGCN --nhid=16 --epochs=1000 --lr=0.01  --weight_decay=5e-4 \
 --seed= --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --use_feats

python main.py --task=nc --dataset=pubmed --model=HGCN --nhid=16 --epochs=1000 --lr=0.01  --weight_decay=5e-4 \
 --seed= --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --use_feats

python main.py --task=nc --dataset=airport --model=HGCN --nhid=16 --epochs=1000 --lr=0.01  --weight_decay=5e-4 \
 --seed= --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --use_feats

python main.py --task=nc --dataset=ogbn-arxiv --model=HGCN --nhid=16 --epochs=1000 --lr=0.01  --weight_decay=5e-7 \
 --seed= --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --use_feats

python main.py --task=nc --dataset=fb100 --model=HGCN --nhid=16 --epochs=1000 --lr=0.01  --weight_decay=5e-7 \
 --seed= --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --use_feats

python main.py --task=nc --dataset=twitch_gamer --model=HGCN --nhid=16 --epochs=1000 --lr=0.001  --weight_decay=5e-7 \
 --seed= --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --use_feats

#To run kGCN:

python main.py --task=nc --dataset=cora --model=kGCN --prod_manifold_s=8 --prod_manifold_h=8 --epochs=1000 --lr=0.01 \
 --weight_decay=5e-4  --seed= --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --dropout=0.0 --use_feats

python main.py --task=nc --dataset=citeseer --model=kGCN --prod_manifold_s=8 --prod_manifold_h=8 --epochs=1000 --lr=0.01 \
  --weight_decay=5e-4  --seed= --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --dropout=0.0 --use_feats

python main.py --task=nc --dataset=pubmed --model=kGCN --prod_manifold_s=8 --prod_manifold_h=8 --epochs=1000 --lr=0.01 \
 --weight_decay=5e-4  --seed= --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --dropout=0.0 --use_feats

python main.py --task=nc --dataset=airport --model=kGCN --prod_manifold_s=8 --prod_manifold_h=8 --epochs=1000 --lr=0.01 \
 --weight_decay=5e-4  --seed= --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --dropout=0.0 --use_feats

python main.py --task=nc --dataset=fb100 --model=kGCN --prod_manifold_s=8 --prod_manifold_h=8 --epochs=1000 --lr=0.01 \
 --weight_decay=5e-7  --seed= --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --dropout=0.0 --use_feats

python main.py --task=nc --dataset=ogbn-arxiv  --model=kGCN --prod_manifold_s=8 --prod_manifold_h=8 --epochs=1000 --lr=0.01 \
 --weight_decay=5e-7  --seed=  --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --dropout=0.0 --use_feats (2 layers)

python main.py --task=nc --dataset=twitch_gamer  --model=kGCN --prod_manifold_s=8 --prod_manifold_h=8 --epochs=1000 --lr=0.01 \
 --weight_decay=5e-7  --seed=  --using_riemannianAdam=True --act=elu --patience=300 --step_lr=1000 --dropout=0.0 --use_feats (2 layers)

#To run QGCN:

python main.py --task=nc --dataset=cora --model=QGCN --time_dim=14 --space_dim=2  --epochs=1000 --lr=0.05 \
 --weight_decay=5e-4  --seed= --using_riemannianAdam=True --act=tanh --patience=1000 --step_lr=1000 --dropout=0.7 --use_feats (1 layer)

python main.py --task=nc --dataset=citeseer --model=QGCN --time_dim=8 --space_dim=8  --epochs=1000 --lr=0.05 \
 --weight_decay=5e-4  --seed= --using_riemannianAdam=True --act=tanh --patience=1000 --step_lr=1000 --dropout=0.6 --use_feats (1 layer)

python main.py --task=nc --dataset=pubmed --model=QGCN --time_dim=14 --space_dim=2  --epochs=1000 --lr=0.05 \
 --weight_decay=5e-4  --seed= --using_riemannianAdam=True --act=tanh --patience=1000 --step_lr=1000 --dropout=0.7 --use_feats (1 layer)

python main.py --task=nc --dataset=airport --model=QGCN --time_dim=15 --space_dim=1 --epochs=1000 --lr=0.01 \
 --weight_decay=1e-4  --seed= --using_riemannianAdam=True --act=tanh --patience=1000 --step_lr=1000 --dropout=0.0 --use_feats (2 layers)

python main.py --task=nc --dataset=ogbn-arxiv --model=QGCN --time_dim=15 --space_dim=1 --epochs=1000 --lr=0.01 \
 --weight_decay=5e-7  --seed= --using_riemannianAdam=True --act=tanh --patience=1000 --step_lr=1000 --dropout=0.0 --use_feats (3 layers)

python main.py --task=nc --dataset=fb100 --model=QGCN --time_dim=15 --space_dim=1 --epochs=1000 --lr=0.02 \
 --weight_decay=5e-7  --seed= --using_riemannianAdam=True --act=tanh --patience=1000 --step_lr=1000 --dropout=0.0 --use_feats (2 layers)

python main.py --task=nc --dataset=twitch_gamer --model=QGCN --time_dim=16 --space_dim=0 --epochs=1000 --lr=0.005 \
 --weight_decay=5e-7  --seed= --using_riemannianAdam=True --act=tanh --patience=1000 --step_lr=1000 --dropout=0.0 --use_feats (1 layer)

#To run QGCN2:

python main.py --task=nc --dataset=cora --model=QGCN2 --time_dim=14 --space_dim=2 --epochs=1000 --lr=0.005 \
 --weight_decay=1e-1  --seed= --using_riemannianAdam=True --act=tanh --patience=1000 --step_lr=1000 --dropout=0.0 --use_feats (2 layers, gcn encoder, residual) 

python main.py --task=nc --dataset=citeseer --model=QGCN2 --time_dim=8 --space_dim=8 --epochs=1000 --lr=0.005 \
 --weight_decay=1e-1 --seed= --using_riemannianAdam=True --act=tanh --patience=1000 --step_lr=1000 --dropout=0.0 --use_feats --normalize_feats (2 layers, linear encoder, no residual) 

python main.py --task=nc --dataset=pubmed --model=QGCN2 --time_dim=14 --space_dim=2 --epochs=1000 --lr=0.005 \
 --weight_decay=1e-1  --seed= --using_riemannianAdam=True --act=tanh --patience=1000 --step_lr=1000 --dropout=0.0 --use_feats --normalize_feats (2 layers, no residual, linear encoder) 

python main.py --task=nc --dataset=airport --model=QGCN2 --time_dim=15 --space_dim=1 --epochs=1000 --lr=0.01 \
 --weight_decay=5e-4  --seed= --using_riemannianAdam=True --act=relu --patience=1000 --step_lr=1000  --dropout=0.0 --use_feats (2 layers, no residual, gcn encoder) 

python main.py --task=nc --dataset=ogbn-arxiv --model=QGCN2 --time_dim=15 --space_dim=1 --epochs=1000 --lr=0.01 \
 --weight_decay=5e-7  --seed= --using_riemannianAdam=True --act=tanh --patience=1000 --step_lr=1000  --dropout=0.0 --use_feats (2 layers, no residual, no gcn encoder) 

python main.py --task=nc --dataset=fb100 --model=QGCN2 --time_dim=15 --space_dim=1 --epochs=1000 --lr=0.01 \
 --weight_decay=5e-7  --seed= --using_riemannianAdam=True --act=tanh --patience=1000 --step_lr=1000  --dropout=0.0 --use_feats (2 layers, no residual, no gcn encoder) 

python main.py --task=nc --dataset=twitch_gamer --model=QGCN2 --time_dim=16 --space_dim=0 --epochs=1000 --lr=0.001 \
 --weight_decay=5e-7  --seed= --using_riemannianAdam=True --act=relu --patience=1000 --step_lr=1000  --dropout=0.0 --use_feats (2 layers, no residual, no gcn encoder) 

#To run GraphGPS:

python main.py --task=nc --dataset=cora --model=GraphGPS --trans_num_layers=3  --trans_num_heads=2  --epochs=1000 \
 --lr=0.01  --weight_decay=5e-7  --seed= --using_riemannianAdam=False --patience=300 --step_lr=1000  --dropout=0.5 --use_feats

python main.py --task=nc --dataset=citeseer --model=GraphGPS --trans_num_layers=1  --trans_num_heads=1  --epochs=1000 \
 --lr=0.01  --weight_decay=5e-7  --seed= --using_riemannianAdam=False --patience=300 --step_lr=1000  --dropout=0.5 --use_feats

python main.py --task=nc --dataset=pubmed --model=GraphGPS --trans_num_layers=2  --trans_num_heads=1  --epochs=1000 \
 --lr=0.01  --weight_decay=5e-7  --seed= --using_riemannianAdam=False --patience=300 --step_lr=1000  --dropout=0.5  --use_feats

python main.py --task=nc --dataset=airport --model=GraphGPS --trans_num_layers=3  --trans_num_heads=1  --epochs=1000 \
 --lr=0.01  --weight_decay=5e-7  --seed= --using_riemannianAdam=False --patience=300 --step_lr=1000  --dropout=0.5 --use_feats

#To run NodeFormer:

python main.py --task=nc --dataset=cora --model=NodeFormer --trans_num_layers=2  --trans_num_heads=2  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --lamda=1.0  --seed= --using_riemannianAdam=False --patience=1000 --step_lr=1000  --dropout=0.0 --rb_order=3 --use_feats

python main.py --task=nc --dataset=citeseer --model=NodeFormer --trans_num_layers=2  --trans_num_heads=4  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-3 --lamda=1.0  --seed= --using_riemannianAdam=False --patience=1000 --step_lr=1000  --dropout=0.5 --rb_order=3 --use_feats

python main.py --task=nc --dataset=pubmed --model=NodeFormer --trans_num_layers=2  --trans_num_heads=2  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --lamda=1.0  --seed= --using_riemannianAdam=False --patience=1000 --step_lr=1000  --dropout=0.3 --rb_order=2 --use_feats

python main.py --task=nc --dataset=airport --model=NodeFormer --trans_num_layers=2  --trans_num_heads=2  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --lamda=1.0  --seed= --using_riemannianAdam=False --patience=1000 --step_lr=1000  --dropout=0.0 --rb_order=2 --use_feats

python main.py --task=nc --dataset=ogbn-arxiv --model=NodeFormer --trans_num_layers=1  --trans_num_heads=1  --epochs=1000 \
 --lr=0.005 --weight_decay=5e-4 --lamda=1.0  --seed= --using_riemannianAdam=False --patience=300 --step_lr=1000  --dropout=0.0 --rb_order=2  --use_feats

python main.py --task=nc --dataset=fb100 --model=NodeFormer --trans_num_layers=2  --trans_num_heads=2  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --lamda=1.0  --seed= --using_riemannianAdam=False --patience=300 --step_lr=1000  --dropout=0.0 --rb_order=1 --use_feats

python main.py --task=nc --dataset=twitch_gamer --model=NodeFormer --trans_num_layers=1  --trans_num_heads=2  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --lamda=1.0  --seed= --using_riemannianAdam=False --patience=300 --step_lr=1000  --dropout=0.0 --rb_order=1 --use_feats

# To run SGFormer

python main.py --task=nc --dataset=cora --model=SGFormer --trans_num_layers=3  --trans_num_heads=1  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --seed= --using_riemannianAdam=False --patience=300 --step_lr=1000  --dropout=0.5 --use_feats
 (gnn_num_layers=3, gnn_dropout=0.5, gnn_use_weight=False, gnn_use_init=False, gnn_use_bn=False, gnn_use_residual=True, 
  gnn_use_act=True, use_graph=True, graph_weight=0.8)

python main.py --task=nc --dataset=citeseer --model=SGFormer --trans_num_layers=4  --trans_num_heads=1  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --seed= --using_riemannianAdam=False --patience=1000 --step_lr=1000  --dropout=0.5 --use_feats
 (gnn_num_layers=4, gnn_dropout=0.5, gnn_use_weight=False, gnn_use_init=False, gnn_use_bn=False, gnn_use_residual=True, 
  gnn_use_act=True, use_graph=True, graph_weight=0.7)

python main.py --task=nc --dataset=pubmed --model=SGFormer --trans_num_layers=3  --trans_num_heads=1  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --seed= --using_riemannianAdam=False --patience=1000 --step_lr=1000  --dropout=0.5 --use_feats
(gnn_num_layers=3, gnn_dropout=0.5, gnn_use_weight=False, gnn_use_init=False, gnn_use_bn=False, gnn_use_residual=True, 
 gnn_use_act=True, use_graph=True, graph_weight=0.8)

python main.py --task=nc --dataset=airport --model=SGFormer --trans_num_layers=3  --trans_num_heads=1  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --seed= --using_riemannianAdam=False --patience=1000 --step_lr=1000  --dropout=0.0 --use_feats
(gnn_num_layers=3, gnn_dropout=0.0, gnn_use_weight=False, gnn_use_init=False, gnn_use_bn=False, gnn_use_residual=True, 
 gnn_use_act=True, use_graph=True, graph_weight=0.8) 

arxiv: run SGFormer github

python main.py --task=nc --dataset=fb100 --model=SGFormer --trans_num_layers=4  --trans_num_heads=1  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --seed= --using_riemannianAdam=False --patience=1000 --step_lr=1000  --dropout=0.5  --use_feats
(gnn_num_layers=4, gnn_dropout=0.5, gnn_use_weight=False, gnn_use_init=False, gnn_use_bn=False, gnn_use_residual=True, 
 gnn_use_act=True, use_graph=True, graph_weight=0.7) 

python main.py --task=nc --dataset=twitch_gamer --model=SGFormer --trans_num_layers=3 --trans_num_heads=1 --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --seed= --using_riemannianAdam=False --patience=1000 --step_lr=1000 --dropout=0.0  --use_feats
(gnn_num_layers=4, gnn_dropout=0.0, gnn_use_weight=False, gnn_use_init=False, gnn_use_bn=False, gnn_use_residual=True,
 gnn_use_act=True, use_graph=True, graph_weight=0.7) 

 # To run Hypformer

python main.py --task=nc --dataset=cora --model=Hypformer  --trans_num_layers=1  --trans_num_heads=1  --epochs=1000 \
 --lr=0.005 --weight_decay=5e-4 --seed=  --using_riemannianAdam=True --patience=1000 --step_lr=1000  --dropout=0.5  \
 --curvature_out=3.0  --use_feats
 (gnn_num_layers=3, gnn_dropout=0.5, gnn_use_weight=False, gnn_use_init=False, gnn_use_bn=False, gnn_use_residual=True, 
 gnn_use_act=True, use_graph=True, graph_weight=0.8)

python main.py --task=nc --dataset=citeseer --model=Hypformer  --trans_num_layers=1  --trans_num_heads=1  --epochs=1000 \
 --lr=0.005 --weight_decay=5e-4 --seed=  --using_riemannianAdam=True --patience=1000 --step_lr=1000  --dropout=0.5  \
 --curvature_out=4.0 --use_feats
 (gnn_num_layers=3, gnn_dropout=0.5, gnn_use_weight=False, gnn_use_init=False, gnn_use_bn=False, gnn_use_residual=True, 
 gnn_use_act=True, use_graph=True, graph_weight=0.8)

python main.py --task=nc --dataset=pubmed --model=Hypformer  --trans_num_layers=1  --trans_num_heads=1  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --seed=  --using_riemannianAdam=True --patience=1000 --step_lr=1000  --dropout=0.5 \
  --curvature_out=4.0 --use_feats
(gnn_num_layers=3, gnn_dropout=0.5, gnn_use_weight=False, gnn_use_init=False, gnn_use_bn=False, gnn_use_residual=True, 
gnn_use_act=True, use_graph=True, graph_weight=0.8) 

python main.py --task=nc --dataset=airport --model=Hypformer  --trans_num_layers=1  --trans_num_heads=1  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-4 --seed=  --using_riemannianAdam=True --patience=1000 --step_lr=1000  --dropout=0.0 \
  --curvature_out=3.0 --use_feats
(gnn_num_layers=3, gnn_dropout=0.0, gnn_use_weight=False, gnn_use_init=False, gnn_use_bn=False, gnn_use_residual=True, 
gnn_use_act=True, use_graph=True, graph_weight=0.8) 

arxiv: run in Hypformer github

python main.py --task=nc --dataset=fb100 --model=Hypformer  --trans_num_layers=1  --trans_num_heads=1  --epochs=1000 \
 --lr=0.01 --weight_decay=5e-7 --seed=  --using_riemannianAdam=True --patience=1000 --step_lr=1000  --dropout=0.4 \
  --curvature_out=1.0 --use_feats
(gnn_num_layers=3, gnn_dropout=0.5, gnn_use_weight=False, gnn_use_init=False, gnn_use_bn=False, gnn_use_residual=True, 
gnn_use_act=True, use_graph=True, graph_weight=0.8) 

python main.py --task=nc --dataset=twitch_gamer --model=Hypformer  --trans_num_layers=1  --trans_num_heads=1 \
 --epochs=1000 --lr=0.01 --weight_decay=5e-7 --seed=  --using_riemannianAdam=True --patience=1000 --step_lr=1000 \
  --dropout=0.0  --curvature_out=1.0 --use_feats
(gnn_num_layers=3, gnn_dropout=0.0, gnn_use_weight=False, gnn_use_init=False, gnn_use_bn=False, gnn_use_residual=True, 
gnn_use_act=True, use_graph=True, graph_weight=0.8) 

# To run QGT

python main.py --task=nc --dataset=cora --model=QGT --trans_num_layers=3 --trans_num_heads=1 --epochs=1000 \
 --lr=0.002 --seed=1234 --patience=1000 --min_epoch=250  --act=tanh --time_dim=14 --space_dim=2  --graph_num_layers=4 \
 --graph_weight=0.8 --weight_decay=1e-1 --weight_decay_2=1e-1 --weight_decay_3=5e-2 --normalize_feats --dropout_time=0.2 \
 --dropout_space=0.2 --g_dropout_time=0.0 --g_dropout_space=0.0 --use_feats

python main.py --task=nc --dataset=pubmed --model=QGT --trans_num_layers=3 --trans_num_heads=1 --epochs=1000 --lr=0.005 \
 --seed=1234 --patience=1000 --min_epoch=1000  --act=tanh --time_dim=14 --space_dim=2  --graph_num_layers=4 \
 --graph_weight=0.8 --weight_decay=1e-2 --weight_decay_2=5e-4 --weight_decay_3=1e-1 --normalize_feats \
 --dropout_time=0.3 --dropout_space=0.0 --g_dropout_time=0.4 --g_dropout_space=0.0 --use_feats

python main.py --task=nc --dataset=citeseer --model=QGT --trans_num_layers=3 --trans_num_heads=1 --epochs=1000 \
 --lr=0.002 --seed=1234 --patience=1000 --min_epoch=250  --act=tanh --time_dim=8 --space_dim=8  --graph_num_layers=2 \
 --graph_weight=0.8 --weight_decay=1e-1 --weight_decay_2=1e-1 --weight_decay_3=5e-2 --normalize_feats --dropout_time=0.2 \
 --dropout_space=0.2 --g_dropout_time=0.0 --g_dropout_space=0.0 --use_feats --trans_use_bn

python main.py --task=nc --dataset=airport --model=QGT --trans_num_layers=1 --trans_num_heads=1 --epochs=1000 --lr=0.005 \
 --seed=1234 --patience=1000 --min_epoch=250  --act=relu --time_dim=15 --space_dim=1  --graph_num_layers=3 \
 --graph_weight=0.8 --weight_decay=5e-4 --weight_decay_2=5e-4 --weight_decay_3=5e-4 --dropout_time=0.0 \
 -dropout_space=0.0 --g_dropout_time=0.0 --g_dropout_space=0.0  --use_feats

python main.py --task=nc --dataset=ogbn-arxiv --model=QGT --trans_num_layers=1 --trans_num_heads=1 --epochs=1000 \
 --lr=0.005 --seed=1234 --patience=1000 --min_epoch=250  --act=tanh --time_dim=15 --space_dim=1  --graph_num_layers=3 \
 --graph_weight=0.5 --weight_decay=5e-7 --weight_decay_2=5e-7 --weight_decay_3=5e-7 --dropout_time=0.0 \
 --dropout_space=0.0 --g_dropout_time=0.0 --g_dropout_space=0.0  --use_feats

python main.py --task=nc --dataset=fb100 --model=QGT --trans_num_layers=1 --trans_num_heads=1 --epochs=1000 \
 --lr=0.001 --seed=1234 --patience=1000 --min_epoch=250  --act=tanh --time_dim=15 --space_dim=1  \
 --graph_num_layers=2 --graph_weight=0.9 --weight_decay=5e-12 --weight_decay_2=5e-12 --weight_decay_3=5e-12 \
 --dropout_time=0.4 --dropout_space=0.0 --g_dropout_time=0.4 --g_dropout_space=0.0 --normalize_feats --use_feats

python main.py --task=nc --dataset=twitch_gamer --model=QGT --trans_num_layers=1 --trans_num_heads=1 --epochs=1000 \
 --lr=0.05 --seed=1234 --patience=1000 --min_epoch=250  --act=tanh --time_dim=16 --space_dim=0  --graph_num_layers=2 \
 --graph_weight=0.7 --weight_decay=5e-4 --weight_decay_2=5e-4 --weight_decay_3=5e-4 --dropout_time=0.4 \
 --dropout_space=0.0 --g_dropout_time=0.4 --g_dropout_space=0.0 --normalize_feats  --use_feats