#!/bin/bash
set -e
cd "$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"/

model_list=("vgg11" "resnet18" "resnet34")
dataset_list=("svhn" "cifar10" "cifar100")
part_strategy_list=("iid" "labeldir0.5" "labeldir0.1")
lr_list=(0.01 0.1 0.1)
round_list=(100 200 200)

epochs=5
batch_size=64
num_client=10
save_round=0

gpu=(0 0 1 1 1 2 2 2 3 3) 
gpus=3
ip="0.0.0.0:13000"

for b in {0..0}; do # model
    model=${model_list[${b}]}
    dataset=${dataset_list[${b}]}
    rounds=${round_list[${b}]}
    lr=${lr_list[${b}]}

    for a in {1..1}; do  # part_strategy
        part_strategy=${part_strategy_list[${a}]}
        
        dir="../log/${dataset}/${dataset}+${part_strategy}/${model}+fedavg/"
        name="${dataset}+${part_strategy}+${model}+fedavg"
        python ../federated_basetrain/server.py \
        --model ${model} --dataset ${dataset} --lr ${lr} \
        --rounds ${rounds} --epochs ${epochs} --batch_size ${batch_size} --num_client ${num_client} --save_round ${save_round} \
        --gpu ${gpus} --ip ${ip} --log_dir ${dir} --log_name ${name} &
        sleep 10 
        for i in $(seq 0 $(($num_client-1))); do
            echo "starting client $i"
            python ../federated_basetrain/client_fedavg.py \
            --model ${model} --dataset ${dataset} --part_strategy ${part_strategy} \
            --num_client ${num_client} --id ${i} --gpu ${gpu[${i}]} --ip ${ip} --log_dir ${dir} --log_name ${name} &
        done
        trap "trap - SIGTERM && kill -- -$$" SIGINT SIGTERM 
        wait
    done 
done
