#!/bin/bash
set -e
cd "$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"/

model="bif-resnet34" 
dataset="cifar100"
part_strategy=("iid" "labeldir0.5" "labeldir0.1")
lr=0.1
rounds=200 
epochs=5
batch_size=64
num_client=10
save_round=0

train_mask="1111" 
tune_mask=1 

gpu=(0 0 1 1 1 2 2 2 3 3) 
gpus=3
ip="0.0.0.0:13000"

# gpu=(0 0 0 1 1 1 2 2 2 2) 
# gpus=1
# ip="localhost:13000" # for windows

for h in {1..1}; do   
    dir="../log/${dataset}/${dataset}+${part_strategy[${h}]}/${model}+fedbif/${tune_mask}+${train_mask}/"
    name="${dataset}+${part_strategy[${h}]}+${model}+fedbif+${tune_mask}"
    python ../federated_train/server_fedbif.py \
    --model "vgg11" --dataset ${dataset} --lr ${lr} --tune_mask ${tune_mask} --train_mask ${train_mask} \
    --rounds ${rounds} --epochs ${epochs} --batch_size ${batch_size} --num_client ${num_client} --save_round ${save_round} \
    --gpu ${gpus} --ip ${ip} --log_dir ${dir} --log_name ${name} &
    sleep 10 
    for i in $(seq 0 $(($num_client-1))); do
        echo "starting client $i"
        python ../federated_train/client_fedbif.py \
        --model ${model} --dataset ${dataset} --part_strategy ${part_strategy[${h}]} --num_client ${num_client} --id ${i} \
        --train_mask ${train_mask} --gpu ${gpu[${i}]} --ip ${ip} --log_dir ${dir} --log_name ${name} &
    done
    trap "trap - SIGTERM && kill -- -$$" SIGINT SIGTERM 
    wait
done

