# FedBiF

This repository contains the code implementation of the research paper titled "FedBiF: Communication-Efficient Federated Learning via Bits Freezing". The code allows you to run the proposed FedBiF as well as several baselines (FedAvg, FedPAQ, FedDQ, DAdaQuant and SignSGD) on three datasets (SVHN, CIFAR-10, CIFAR-100) under both IID and Non-IID data settings.

We have utilized [Flower](https://github.com/adap/flower), a widely used federated learning framework, as the foundation for conducting our experiments. Additionally, we refer to [NIID-Bench](https://github.com/Xtra-Computing/NIID-Bench), a federated learning benchmark on Non-IID data distribution, to process the datasets.

## Environment Setup
please execute the following command to install the necessary dependencies:
```
pip install -r requirements.txt
```


## Data Partition
Run the following code to download and partition datasets:
```
python ./federated_dataloader/data_partition.py 
```

## Virtual Bits Initialization for FedBiF
Prior to training, we initialize the virtual bits of each model and save them. During training, each client loads the saved virtual bits to ensure consistent initial virtual bits across all clients. To perform this initialization, run the following command:

```
python ./federated_train/init_bits.py 
```

## Run FedBiF
Run the following code to start FedBiF. `federated_shell/0-all.sh` starts three sub-shell to run FedBiF on three datasets, respectively:
```
./federated_shell/0-all.sh 
```

## Run Basleines
Run the following code to start all baselines. `./federated_baseshell/0-all.sh ` starts five sub-shell to run all baselines on three datasets, respectively:
```
./federated_baseshell/0-all.sh 
```
