#!/bin/bash


epochs=1000

function test () {
  train_options=$1
  dist=$2
  echo python3 print_exp_dir.py ${train_options}

  model_path=`python3 print_exp_dir.py ${train_options}`

  echo ${model_path}
  for test_N in 20 30; do
    test_dat="./datasets/test/${dist}_size-$(printf "%02d" ${test_N})_test.dat"
    echo python3 test.py ${model_path}/$(printf "%05d" ${epochs})_net.pth ${test_dat}

    python3 test.py ${model_path}/$(printf "%05d" ${epochs})_net.pth ${test_dat}

  done
}


# for SEq and Bal
for fair_loss in lf lb; do

    train_N=30
    
    # sym and dual for UD, Lib(LL)
    for dist in UD LL; do
        ## WeaveNet-60-sym
        train_options="--network_type WeaveNet -L 60 -w 64 -W 64 -N ${train_N} ${train_N} -d ${dist} -e ${epochs} --pin_memory --non_blocking --num_workers=2 --cudnn_benchmark --validation 10 -#{fair_loss} 0.01"

        echo python3 train.py ${train_options}
        python3 train.py ${train_options}
        test "${train_options}" $dist


        ## WeaveNet-60-dual
        train_options="--network_type WeaveNetDual -L 60 -w 64 -W 64 -N ${train_N} ${train_N} -d ${dist} -e ${epochs} --pin_memory --non_blocking --num_workers=2 --cudnn_benchmark --validation 10 -#{fair_loss} 0.01"

        echo python3 train.py ${train_options}
        python3 train.py ${train_options}
        test "${train_options}" $dist

    done

    for dist in UU DD GG UD LL; do
        ## WeaveNet-60(20)
        train_N=20
        train_options="--network_type WeaveNet -L 60 -w 64 -W 64 -N ${train_N} ${train_N} -d ${dist} -e ${epochs} --pin_memory --non_blocking --num_workers=2 --cudnn_benchmark --validation 10 -#{fair_loss} 0.01"
        if [ $dist = "UD" -o $dist = "LL" ]; then
          train_options="${train_options} -a"
        fi

        echo python3 train.py ${train_options}
        python3 train.py ${train_options}
        test "${train_options}" $dist        

        # SSWN-60
        train_N=30
        train_options="--network_type SSWN -L 60 -w 64 -W 64 -N ${train_N} ${train_N} -d ${dist} -e ${epochs} --pin_memory --non_blocking --num_workers=2 --cudnn_benchmark --validation 10 -#{fair_loss} 0.01"
        if [ $dist = "UD" -o $dist = "LL" ]; then
          train_options="${train_options} -a"
        fi
        echo python3 train.py ${train_options}
        python3 train.py ${train_options}
        test "${train_options}" $dist    
    done
done
