#!/bin/bash

dist_dir=test
mkdir -p datasets/${dist_dir}

# validation data for non-flexible networks (such as MLP).
seed=36295

for N in 03 05 07 09; do
  #for dist in UU UD DD GG LL; do
  for dist in UU; do
    python3 generate_dataset.py -N $N --distrib_m ${dist:0:1} --distrib_f ${dist:1:2} --dist_dir $dist_dir --seed ${seed}
    cd datasets/${dist_dir}; find ${dist}/size-${N}/* | grep .npz | sort -n > ${dist}_size-${N}_${dist_dir}.dat; cd ../../
  done
done

seed=135789 

for N in 03 05 07 09; do
  #for dist in UU UD DD GG LL; do
  for dist in UU; do 
    echo python3 generate_dataset.py -N $N --distrib_m ${dist:0:1} --distrib_f ${dist:1:2} --dist_dir $dist_dir --brute_force --seed ${seed}
    cd datasets/${dist_dir}; find ${dist}/size-${N}/* | grep .npz | sort -n > ${dist}_size-${N}_${dist_dir}.dat; cd ../../
  done
done

# For the N=10 validation, we used the same seed with the N<10 test sets due to a historical reason.
dist_dir=validation
for N in 10; do
  #for dist in UU UD DD GG LL; do
  for dist in UU; do
    #echo "Note: Enumerate all stable matching (by --brute_force option) with N=10 may take more than whole one week 
    # although it prunes search by finding any blocking pair. If you really need to enumerate it, better to implement rotation poset and enumerates all cut of the poset."
    echo python3 generate_dataset.py -N $N --distrib_m ${dist:0:1} --distrib_f ${dist:1:2} --dist_dir $dist_dir --seed ${seed} 
    cd datasets/${dist_dir}; find ${dist}/size-${N}/* | grep .npz | sort -n > ${dist}_size-${N}_${dist_dir}.dat; cd ../../
  done
done


