#!/bin/bash

# generate datasets for test (5x5, UU)
test_N=05
dist_dir=test
mkdir -p datasets/${dist_dir}
dist="UU"
echo python3 generate_dataset.py -N ${test_N} --distrib_m ${dist:0:1} --distrib_f ${dist:1:2} --dist_dir $dist_dir --brute_force --seed 135789
python3 generate_dataset.py -N ${test_N} --distrib_m ${dist:0:1} --distrib_f ${dist:1:2} --dist_dir $dist_dir --brute_force --seed 135789
cd datasets/${dist_dir}; find ${dist}/size-${test_N}/* | grep .npz | sort -n > ${dist}_size-${test_N}_${dist_dir}.dat; cd ../../

# generate datasets for validation (10x10, UU)

train_N=10
dist_dir=validation
mkdir -p datasets/${dist_dir}
echo python3 generate_dataset.py -N ${train_N} --distrib_m ${dist:0:1} --distrib_f ${dist:1:2} --dist_dir $dist_dir --seed 135789
python3 generate_dataset.py -N ${train_N} --distrib_m ${dist:0:1} --distrib_f ${dist:1:2} --dist_dir $dist_dir --seed 135789
cd datasets/${dist_dir}; find ${dist}/size-${train_N}/* | grep .npz | sort -n > ${dist}_size-${train_N}_${dist_dir}.dat; cd ../../


epochs=1000
train_options="--network_type WeaveNet -N ${train_N} ${train_N} -d ${dist} -e ${epochs} --pin_memory --non_blocking --cudnn_benchmark --validation ${epochs}"
echo python3 train.py ${train_options}
python3 train.py ${train_options}

model_path=`python3 print_exp_dir.py ${train_options}`
echo ${model_path}

test_dat="./datasets/test/${dist}_size-$(printf "%02d" ${test_N})_test.dat"
echo python3 test.py ${model_path}/$(printf "%05d" ${epochs})_net.pth ${test_dat}
python3 test.py ${model_path}/$(printf "%05d" ${epochs})_net.pth ${test_dat}

