#!/bin/bash

for dist_dir in validation test; do
  mkdir -p datasets/${dist_dir}
  for N in 20 30; do
    for dist in UU UD DD GG LL; do      
      python3 generate_dataset.py -N $N --distrib_m ${dist:0:1} --distrib_f ${dist:1:2} --dist_dir ${dist_dir}
      cd datasets/${dist_dir}; find ${dist}/size-${N}/* | grep .npz | sort -n > ${dist}_size-${N}_${dist_dir}.dat; cd ../../
    done
  done
done
