# DiracDiffusion
To install dependencies run
```
pip install -r requirements.txt
```
We tested the code using 
- Python 3.8
- Torch 1.12.1
- CUDA 11.1

## Training example
To train a deblurring model on the CelebA-HQ dataset, run the command
```
python ddpm_examples/train_increc_celeba256.py --data_path DATA_PATH \
                                                --default_root_dir OUTPUT_DIR \
                                                --experiment_config_file 'configs/experiments/gaussian_blur.yaml' \
                                                --devices 8 \
                                                --sample_rates 1.0 1.0 1.0 \
                                                --batch_size 4 \
                                                --max_epochs 300 \
                                                --lr 0.0001 \
                                                --num_steps 50 \
                                                --check_val_every_n_epoch 1\
                                                --weight_decay 0.0 \
                                                --experiment_name 'dirac-celeba256' \
                                                --full_val_only_last_epoch \
                                                --save_checkpoints
```
where `DATA_PATH` should point to the CelebA-HQ 256x256 resized data root directory. 
For ImageNet experiments, `DATA_PATH` should point to the root directory containing both `train` and `val` splits.

## Reconstruction example
To run the trained model on 100 images from the validation set, run
```
python ddpm_examples/reconstruction_celeba256.py --data_path DATA_PATH \
                                                --recon_config_path 'configs/reconstruction/blur/celeba256.yaml' \
                                                --model_ckpt_path MODEL_PATH \
                                                --output_path 'outputs' \
                                                --experiment_name 'celeba256_deblur' \
                                                --num_images 100 \
                                                --save_outputs \
                                                --eval_results
```
where MODEL_PATH points to the trained `.ckpt` file. The reconstructions will be automatically saved  in the output folder,
along with the noisy and target images. Evaluation metrics will be calculated and the evolution of different metrics plotted
in the `eval` folder. 
