"""
Utilities for example scripts.
"""
import pathlib
import yaml
import torch
import numpy as np

def load_config_from_yaml(path):
    config_file = pathlib.Path(path)
    if config_file.exists():
        with config_file.open('r') as f:
            d = yaml.safe_load(f)
        return d
    else:
        raise ValueError('Config file does not exist.')
        
def str2int(s):
    return int.from_bytes(s.encode(), 'little') % (2 ** 32 - 1)
    
def load_np_to_tensor(file, device=None):
    if device is None:
        device = 'cpu'
    return torch.from_numpy(np.load(file)).permute(2, 0, 1).unsqueeze(0).to(device)