import json

from dataset import get_dataset
from utils import normalise_and_trim
from utils import trim_dataset
from comparison import compare_optimizers, grid_search


def main(args):
    a, b = get_dataset(args=args)
    if args['dataset'] == 'abalone': #todo
        a, b = trim_dataset(a, b, args['n_workers'])
    else:
        a, b = normalise_and_trim(a, b, args['n_workers']) 

    num_rows, dim = a.shape
    print(f'Dataset dimensionality: {dim}')
    print(f'Number of rows: {num_rows}')
    print(f"Number of workers: {args['n_workers']}")
    print(f"Per worker: {int(num_rows // args['n_workers'])}")

    # grid_search(a, b, args)
    compare_optimizers(a, b, args)


if __name__ == '__main__':
    with open('args.json', 'r') as f:
        arguments = json.load(f)
    main(arguments)
