import json
import pandas as pd

def load_json(path):
    with open(path, 'r', encoding='utf-8') as f:
        return json.load(f)

def load_json_by_line(path):
    with open(path, 'r', encoding='utf-8') as f:
        data = []
        for line in f.readlines():
            data.append(json.loads(line.strip()))
        return data
    
def write_json(path, data):
    with open(path, 'w', encoding='utf-8') as f:
        json.dump(data, f, indent=4, ensure_ascii=False)

def write_json_by_line(path, data):
    with open(path, 'w', encoding='utf-8') as f:
        pass

def read_xlsx(path, sheet=None):
    return pd.read_excel(path, sheet_name=sheet)