

## WB-VIMA Trained with MoMaGen Data

This repository provides the code to reproduce WB-VIMA results on the Tidy-Table D1 task. It includes scripts for data processing, training, and evaluation.

> The codebased is based on [WB-VIMA](https://github.com/behavior-robot-suite/brs-algo).


## Installation
1. First, install the MoMaGen repository by following its installation instructions.  
2. Then, install this repository:
```bash
cd brs-algo
pip install -e .
```

## Data Processing
MoMaGen generates data that needs to be reformatted for WB-VIMA training. Use the following scripts:

```bash
# Convert MoMaGen data to RoboMimic format
bash 0-0_data_to_rm_tidy_table.sh  

# Convert RoboMimic-format data to BRS format
bash 0-1_data_rm_to_brs_tidy_table.sh  
```

## Policy Training
To train the WB-VIMA policy locally, run:
```bash
bash 1_train_r1_tidy_table.sh
```

## Policy Deployment

To evaluate or deploy a trained WB-VIMA policy in simulation, run:
```bash
bash 2_eval_r1_tidy_table.sh
```

