Certified Robustness on Structural Graph Matching

This repository contains code and trained models for the paper "Certified Robustness on Structural Graph Matching".

1. Outline
The contents of this repository are as follows:
    ----data/ contains the raw data of PascalVOC-Keypoint. You should download the dataset first.
    ----pretrained_models/ contains the trained models of matching methods,  we only download the model of NGMv2 in the folder, you can download all models from https://github.com/Thinklab-SJTU/ThinkMatch.
    ----experiments/ contains the parameter settings of matching methods.
    ----models/ cotains the basic algorithms of matching methods.
    ----ANCER_result/ contains distributions of ANCER method.
    ----Isotropic_DD_result/ contains distributions of DDRS method.
    ----result/ contains all certified results.
    ----figure/ contains all plotted figures of certified results.
  
2. Get Started
(1) The basic running environment is the similar as in https://github.com/Thinklab-SJTU/ThinkMatch. We recommend to use Docker.
     Get the recommended docker image by docker pull runzhongwang/thinkmatch:torch1.6.0-cuda10.1-cudnn7-pyg1.6.3-pygmtools0.2.4
(2) Install other dependencies:
     conda install pandas statsmodels matplotlib seaborn
(3) Download trained models of GMN, PCA-GM, CIE-H and NGMv2.
(4) Download PascalVOC-Keypoint.
    Download VOC2011 dataset from http://host.robots.ox.ac.uk/pascal/VOC/voc2011/index.html and make sure it looks like data/PascalVOC/TrainVal/VOCdevkit/VOC2011
    Download keypoint annotation for VOC2011 from https://drive.google.com/file/d/1D5o8rmnY1-DaDrgAXSygnflX5c-JyUWR/view  and make sure it looks like data/PascalVOC/annotations
    The train/test split is available in data/PascalVOC/voc2011_pairs.npz. This file must be added manually.

3. Scripts
(1) The program certify_deep.py certifies the robustness of deep networks. For example:
    python certify_deep.py --cfg experiments/vgg16_ngmv2_voc.yaml
(2) The program certify_pixel.py certifies the robustness of deep networks when perturbing features. For example:
    python certify_pixel.py --cfg experiments/vgg16_ngmv2_voc.yaml
(3) The programs rrwm_node.py and rrwm_feature.py certify the robustness of RRWM. For example:
    python rrwm_node.py
    python rrwm_feature.py
(4) The programs analyze_deep.py and analyze_rrwm.py can output the figures in the paper. For example:
    python analyze_deep.py
    python analyze_rrwm.py
    And you can change the parameters in these .py file.
 


