import argparse
import numpy as np
from sklearn.linear_model import LinearRegression as LR
from sklearn.preprocessing import normalize
from tqdm import tqdm

argparser = argparse.ArgumentParser(description='Process hyper-parameters')

argparser.add_argument('--eps', type=float, default=0.01, help='misspecification magnitude')
argparser.add_argument('--beta', type=float, default=1, help='beta')
argparser.add_argument('--gamma', type=float, default=0.1, help='threshold')

args = argparser.parse_args()
print(args.eps, args.beta, args.gamma)
cats = normalize(np.load('cat.npy', allow_pickle=True), axis=0)
dogs = normalize(np.load('dog.npy', allow_pickle=True), axis=0)
theta_star = LR(fit_intercept=False).fit(np.vstack((cats, dogs)), np.hstack((np.ones(12500), np.zeros(12500))))

good_cat = np.arange(12500)[(1 - args.eps) < theta_star.predict(cats)]
good_dog = np.arange(12500)[theta_star.predict(dogs) < args.eps]

cum_reg = [[0] for _ in range (8)]
for ind in range(8):
    U = np.eye(512)
    Uinv = np.eye(512)
    b = np.zeros(512)
    theta = np.zeros(512)
    for i in tqdm(range(1000000)):
        cat = cats[np.random.choice(good_cat)]
        dog = dogs[np.random.choice(good_dog)]
        u_cat = np.sqrt(np.einsum('i, ij, j', cat, Uinv, cat))
        u_dog = np.sqrt(np.einsum('i, ij, j', dog, Uinv, dog))
        r_cat = args.beta * u_cat + np.dot(theta, cat)
        r_dog = args.beta * u_dog + np.dot(theta, dog)
        if r_cat > r_dog:
            rwd = 1
            cum_reg[ind].append(cum_reg[ind][-1])
            u_sel = u_cat
            x_sel = cat
        else:
            rwd = 0
            cum_reg[ind].append(cum_reg[ind][-1] + 1)
            u_sel = u_dog
            x_sel = dog

        if u_sel > args.gamma:
            U += np.outer(x_sel, x_sel)
            b += rwd * x_sel
            Uinv = np.linalg.inv(U)
            theta = np.matmul(Uinv, b)
        
np.array(cum_reg).dump('e{}_b{}_g{}.npy'.format(args.eps, args.beta, args.gamma))
