path_prefix=`pwd`

gpu_id=1
py_file=private_test_scripts/mmoe_transformer/two_robotics_tasks_iclr24.py
task_name=attn_modality_spec
debug=1
if [ $debug -eq 1 ]; then
    max_epochs=3
    is_train=1
    seeds=123
    task_name=debug
else
    max_epochs=100
    is_train=1
    # seeds='123 321 132'
    seeds='123 321 132'
    task_name=iclr_24
fi
# 100.0 5.0
for seed in $seeds
    do
    args="--model-path private_test_scripts/model/two_robotic_tasks_$task_name$seed.pth
    --seed $seed 
    --epochs $max_epochs 
    --is-train $is_train 
    --img-path log/img/two_robotic_tasks_$task_name
    --unlimited-capacity-on-mlp 0 
    --seperate-qkv 1 
    --co-input 1 
    --gate-type NoisyVMoEGate 
    --debug $debug
    --modality-gating-merge 1 
    --training-weight 100.0 5
    --cross-modality-attn 1 
    --cross-depth 1 
    --grad-clip 1
    --tune-gate-weight 1
    --moe-gate-weight 0.1
    --task-gating-merge 1
    --modality-joint 1"
    CUDA_VISIBLE_DEVICES=$gpu_id python -u $py_file ${args}
done

python -m utils.fs_msg_bot $0