Welcome to the code for "Orient Anything," an ICLR 2025 submission.

A few pointers:

- Most of our training and evaluation scripts require the user to pass index files as arguments. These should be .txt files consisting of N lines, each storing the path to either (1) an .npy file containing point clouds or normal vectors sampled from a single shape (these are used for training and validation), or (2) a .obj file storing a mesh for a single shape (these are used at inference time). One can easily create such files using Python's "glob" module. 

- We have included a script "utils/presample_point_clouds_from_mesh.py" to help users normalize meshes and presample point clouds and surface normals for training.

- We have included a script "utils/generate_cube_flips.py" to help users generate the file "24_cube_flips.pt" that stores matrix representations of the 24 members of the octahedral group.

- We use poetry for package and dependency management. Please follow the instructions at https://python-poetry.org/docs/ to install and use poetry.

- We have included pretrained checkpoints for your convenience in the folder "pretrained_ckpts."