def get_dataset_type_by_name(name):
    """
    Utils to retrieve model given its name
    """
    if name == 'AminoDatasetPrecompute':
        from ProtLig_GPCRclassA.amino_GNN.dataset import AminoDatasetPrecompute
        dataset_class = AminoDatasetPrecompute

    elif name == 'AminoConcentrationDatasetPrecompute':
        from ProtLig_GPCRclassA.amino_GNN.concentration.dataset_conc import AminoConcentrationDatasetPrecompute
        dataset_class = AminoConcentrationDatasetPrecompute
    elif name == 'AminoConcentrationDatasetPairsSamplingPrecompute':
        from ProtLig_GPCRclassA.amino_GNN.concentration.dataset_conc import AminoConcentrationDatasetPairsSamplingPrecompute
        dataset_class = AminoConcentrationDatasetPairsSamplingPrecompute
    elif name == 'AminoConcentrationDatasetMeasurementsSamplingPrecompute':
        from ProtLig_GPCRclassA.amino_GNN.concentration.dataset_conc import AminoConcentrationDatasetMeasurementsSamplingPrecompute
        dataset_class = AminoConcentrationDatasetMeasurementsSamplingPrecompute

    elif name == 'AminoEC50RegressionDatasetPrecompute':
        from ProtLig_GPCRclassA.amino_GNN.ec50_regression.dataset_reg import AminoEC50RegressionDatasetPrecompute
        dataset_class = AminoEC50RegressionDatasetPrecompute

    # Other:
    else:
        raise ValueError('Unknown model name: {}'.format(name))

    return dataset_class    

