def get_element_type_by_name(name):
    """
    Utils to retrieve model given its name
    """
    if name == 'AminoElementPrecomputeMasked':
        from ProtLig_GPCRclassA.amino_GNN.element import AminoElementPrecomputeMasked
        dataset_class = AminoElementPrecomputeMasked

    elif name == 'AminoConcentrationElementPrecomputeMasked':
        from ProtLig_GPCRclassA.amino_GNN.concentration.element_conc import AminoConcentrationElementPrecomputeMasked
        dataset_class = AminoConcentrationElementPrecomputeMasked

    # Other:
    else:
        raise ValueError('Unknown model name: {}'.format(name))

    return dataset_class    

