def select_seq_embedding(hparams):
    if hparams['SEQ_MODEL_NAME'] == 'ProtBERT':
        from ProtLig_GPCRclassA.amino_GNN.seq_embedding.prot_bert import make_apply_seqs_model
        from transformers import BertTokenizer, BertConfig, FlaxBertModel
        tokenizer = BertTokenizer.from_pretrained("Rostlab/prot_bert", do_lower_case=False)
        config = BertConfig.from_pretrained("Rostlab/prot_bert", output_hidden_states=True, output_attentions=False)
        seq_model = FlaxBertModel.from_pretrained("Rostlab/prot_bert", from_pt = True, config = config)

        apply_seqs_model = make_apply_seqs_model(seq_model = seq_model, 
                                            tokenizer = tokenizer, 
                                            max_length = hparams['SEQ_MAX_LENGTH'], 
                                            n_partitions = hparams['N_PARTITIONS'])
        return apply_seqs_model

    elif hparams['SEQ_MODEL_NAME'] == 'esm2_t33_650M_UR50D':
        from ProtLig_GPCRclassA.amino_GNN.seq_embedding.ESM2 import make_apply_seqs_model
        from transformers import EsmTokenizer, EsmConfig, EsmModel
        tokenizer = EsmTokenizer.from_pretrained("facebook/esm2_t33_650M_UR50D")
        config = EsmConfig.from_pretrained("facebook/esm2_t33_650M_UR50D")
        seq_model = EsmModel.from_pretrained("facebook/esm2_t33_650M_UR50D", config = config, add_pooling_layer = False)

        apply_seqs_model = make_apply_seqs_model(seq_model = seq_model, 
                                            tokenizer = tokenizer, 
                                            max_length = hparams['SEQ_MAX_LENGTH'], 
                                            n_partitions = hparams['N_PARTITIONS'])
        return apply_seqs_model

    elif hparams['SEQ_MODEL_NAME'] == 'esm2_t48_15B_UR50D':
        from ProtLig_GPCRclassA.amino_GNN.seq_embedding.ESM2 import make_apply_seqs_model
        from transformers import EsmTokenizer, EsmConfig, EsmModel
        tokenizer = EsmTokenizer.from_pretrained("facebook/esm2_t48_15B_UR50D")
        config = EsmConfig.from_pretrained("facebook/esm2_t48_15B_UR50D")
        seq_model = EsmModel.from_pretrained("facebook/esm2_t48_15B_UR50D", config = config, add_pooling_layer = False)

        apply_seqs_model = make_apply_seqs_model(seq_model = seq_model, 
                                            tokenizer = tokenizer, 
                                            max_length = hparams['SEQ_MAX_LENGTH'], 
                                            n_partitions = hparams['N_PARTITIONS'])
        return apply_seqs_model

    else:
        raise ValueError('Unknown SEQ_MODEL_NAME: \t {}'.format(hparams['SEQ_MODEL_NAME']))

    return None