
This is the code for ICLR 2026 submission `From Regression to Dose–Response: A Framework to predict Activity and EC50 for GPCRs`. 

The code is organized as a library, so after installing all the dependencies, run `pip install -e <MAIN_DIR_CONTAINING_SETUP>`. We provided example config files for the i.i.d. case in `ProtLig_GPCRclassA/amino_GNN/configs`. Please note, that these files contain absolute paths, so please adjust them as needed. We trained the models in a multi-gpu setting using jax.pmap. In case of a single GPU training, set `N_PARTITIONS: 1` in the config and adjust `BATCH_SIZE` and `SHUFFLE_BUFFER_SIZE` parameters according to your GPU memory.

Data:
-----
All the preprocessed M2OR data and all the splits used during training are provided in here:
```
https://drive.google.com/file/d/11d7RkYYG-vlY2OYnMPYhiLgaHKGpAdx4/view?usp=drive_link
```
and it is recommended to put them to `ProtLig_GPCRclassA/amino_GNN/Data` folder.

Running:
--------
The main execution file is `ProtLig_GPCRclassA/scripts/main.py`. For example to run the training:
```
python ProtLig_GPCRclassA/scripts/main.py --config ProtLig_GPCRclassA/amino_GNN/configs/train/m2or_conc_mixDiscard_20250501-165522/EC50_random_data/ASMI_DR/ec50_only/config_train_conc_masked_pmap_m2or_conc_mixDiscard_20250501_165522_amino_EC50_20250501_165818_modelV20250214_conc_M_esm2_t33_650M_UR50D_MeasurementLabelSampler_ec50_only_grep8.yml
```

Training and evaluation are two separate configs. The training will save checkpoints of the model and then the evaluation is run on the directory containing all the checkpoints. It loads each checkpoint, evaluates them, and stores the results in the tensorbord logs.


List of dependencies:
---------------------
```
pyhton==3.9
pip install --upgrade pip

pip install rdkit==2025.3.6
pip install pandas==2.3.2
pip install matplotlib==3.9.4
pip install scikit_learn==1.6.1
pip install scipy==1.13.1
pip install biopython==1.85
pip install h5py==3.14.0
pip install tables==3.9.2
pip install torch==2.4.1+cu124 -f https://download.pytorch.org/whl/torch/
pip install transformers==4.29.2
pip install tensorflow==2.12.0

pip install objax==1.8.0
pip install optax==0.2.3
pip install jraph==0.0.6.dev0
pip install flax==0.8.5

pip install jax==0.4.29 jaxlib==0.4.29+cuda12.cudnn91 -f https://storage.googleapis.com/jax-releases/jax_cuda_releases.html

pip install --upgrade "numpy<2"

# Optional -- for data preprocessing
pip install pubchempy
pip install hdbscan
```