# Neuron-level Balance between Stability and Plasticity in Deep Reinforcement Learning

## Table of Contents

- [Introduction](#introduction)
- [Installation](#installation)
- [Usage](#usage)

## Introduction

The project is the code of paper [Neuron-level Balance between Stability and Plasticity in Deep Reinforcement Learning](), which balance the stability and plasticity in deep reinforcement learning with neuron-level technique. The basic code is based on [CleanRL](https://github.com/vwxyzjn/cleanrl?tab=readme-ov-file), a  Deep Reinforcement Learning library that provides high-quality single-file implementation with research-friendly features. 

## Installation
Prerequisites:
* Python >=3.7.1,<3.11
* [Poetry 1.2.1+](https://python-poetry.org)
Follow these steps to install the project:
1. Install dependencies:

    ```bash   poetry install
    poetry install -E atari
    pertry run pip install git+https://github.com/Farama-Foundation/Metaworld.git@master#egg=metaworld
    ```
## Usage

Here are examples of how to run this project:

```bash
# run without hyper-parameters
poetry run python nbsp/sac_meta-world_nbsp.py

# run with hyper-parameters
poetry run python nbsp/sac_meta-world_nbsp.py \
    --seed 1 \
    --env-id window-open_window-close \
    --env-names window-open-v2 window-close-v2 \
    --total-timesteps 1000000 \ 
    --frozen_size 350  # The number of RL skill neurons.
```