# Combining Differential Privacy and Byzantine Resilience in Distributed SGD

The contributed code consists in modified/extended `momentum.py`, `reproduce.py` and `study.py`.

The rest of the code (in `aggregators/`, `attacks/`, `experiments/` and `tools/`) are existing assets that the (anonymized) author authored.

## Reproducing the results

### Software dependencies

Python 3.7.3 has been used to run our scripts.

Besides the standard libraries associated with Python 3.7.3, our scripts have been tested with<sup>2</sup>:

| Library     | Version    |
| ----------- | ---------- |
| numpy       | 1.19.1     |
| torch       | 1.6.0      |
| torchvision | 0.7.0      |
| pandas      | 1.1.0      |
| matplotlib  | 3.0.2      |
| PIL         | 7.2.0      |
| requests    | 2.21.0     |
| urllib3     | 1.24.1     |
| chardet     | 3.0.4      |
| certifi     | 2018.08.24 |
| idna        | 2.6        |
| six         | 1.15.0     |
| pytz        | 2020.1     |
| dateutil    | 2.6.1      |
| pyparsing   | 2.2.0      |
| cycler      | 0.10.0     |
| kiwisolver  | 1.0.1      |
| cffi        | 1.13.2     |

<sup>2</sup><sub>this list was automatically generated (see `get_loaded_dependencies()` in `tools/misc.py`).
Some dependencies depend on others, and some dependencies are optional (e.g., only used to process the results and produce the plots).</sub>

We list below the OS on which our scripts have been tested:
* Debian 10 (GNU/Linux 4.19.171-2 x86_64)
* Ubuntu 18.04.5 LTS (GNU/Linux 4.15.0-128-generic x86_64)

### Hardware dependencies

Although our experiments are time-agnostic, we list below the hardware components used:
* 1 Intel(R) Core(TM) i7-8700K CPU @ 3.70GHz
* 2 Nvidia GeForce GTX 1080 Ti
* 64 GB of RAM

### Command

Our results are reproducible in one command.
In the root directory:
```
$ python3 reproduce.py
```
Please be aware this script will require non-negligible disk space: 895 MB of run data, and 265 MB of graphs.

Depending on the hardware, instructing the script to launch several runs per available GPU may reduce the total runtime.
For instance, to push up to 8 concurrent runs per GPU:
```
$ python3 reproduce.py --supercharge 8
```
On our hardware, reproducing the results with this command takes approximately 2 days.