

# **MICM: Advancing Unsupervised Few-Shot Learning via Masked Image** **Contrastive Modeling**

## 0. Dataset and environment

**miniImageNet dataset:** 

[rec.ustc.edu.cn/share/1341cd00-ffa6-11ed-8581-c30591dc01d6](https://rec.ustc.edu.cn/share/1341cd00-ffa6-11ed-8581-c30591dc01d6)

**conda environment :**

Python 3.8, Pytorch 1.11, CUDA 11.3.

We have prepared a conda YAML file which contains all the python dependencies.

```
conda env create -f environment.yml
```

To activate this conda environment,

```
conda activate MICM
```



## 1.unsupervised train

Take the miniImageNet dataset as an example:

```
python -m torch.distributed.launch --nproc_per_node=8 --master_port=29505 main_micm.py --data_path ./miniImagenet/base --eval_data_path ./dataset/miniImagenet/novel --output_dir ./mini_logs/ --evaluate_freq 50 --visualization_freq 50 --use_fp16 True --lr 0.0005 --epochs 1600 --lambda1 1 --lambda2 0 --lambda3 1 --lambda4 1 --batch_size_per_gpu 64 --global_crops_scale 0.4 1 --local_crops_scale 0.05 0.4
```

The model takes about 1250 epochs to achieve the best results.

## 2. pseudo train

Take the miniImageNet dataset as an example:

```
python -m torch.distributed.launch --nproc_per_node=1 --master_port=29505 main_micm.py --pretrained_path ./mini_logs/_gpu6_2024-01-01_12-41-07/ --pretrained_file checkpoint1250.pth --data_path ./dataset/miniImagenet/base --eval_data_path /./dataset/miniImagenet/novel --output_dir ./mini_logs/ --evaluate_freq 1 --saveckp_freq 1 --visualization_freq 50 --use_fp16 True --lr 0.0005 --epochs 1600 --lambda1 0 --lambda2 0.1 --lambda3 0 --lambda4 1 --batch_size_per_gpu 128 --local_crops_number 0 --global_crops_scale 0.4 1 --local_crops_scale 0.05 0.4
```

The model takes about 3 epochs to achieve the best results.

## 3. evaluate

Take the miniImageNet dataset as an example:


1) Modify the 'server_dict' in eval_micm.py

2) run
```
python eval_micm.py \
--num_ways 5 \
--num_shots 1 \
--server mini \
--output_dir ./mini_logs/ \
--ckp_path ./mini_logs/ \
--ckpt_filename checkpoint01250.pth \
--evaluation_method cosine
```


