import torch
import random
import numpy as np


def set_seed(seed: int) -> None:
    """
    Sets the random seed for reproducibility.

    Args:
        seed (int): The seed value to be used.
    """

    torch.manual_seed(seed)
    np.random.seed(seed)
    random.seed(seed)
    if torch.cuda.is_available():
        torch.cuda.manual_seed(seed)
        torch.cuda.manual_seed_all(seed)
    return None
