## Date: 2022/11/08
## Code: python

# import useful libraries
# import paddle tools
import paddle_quantum
from paddle_quantum import set_backend
from paddle_quantum.state import State

# import simulation related packages
from QuantumLadder import QuantumLadder
from LadderExtenstion import ModelPool

# basic python tools and math related libraries
import numpy as np
from tqdm import tqdm
import json

# drawing tools
from matplotlib import pyplot as plt 
import warnings
warnings.filterwarnings("ignore")

# setting the code accuracy
paddle_quantum.set_dtype("complex128")    
set_backend("state_vector")


def json_store(file_name: str, result_dict: dict = None):
    with open(file_name, 'a') as res_store:
        json.dump(result_dict, res_store)


############################################################
################# Experimental platform ####################
############################################################
# Examing the adaptive method
if __name__ == "__main__":

    # Hyper parameters
    num_qubits = 10
    learning_rate = 0.1
    learning_ITR = 200
    modelname = "test"

    # Storing simulation data
    datalist = []

    # experiment set-up
    for width in tqdm(range(2, int(num_qubits/2)+1)):

        LadderInit = QuantumLadder(num_qubits=num_qubits, ITR=learning_ITR, 
                                   LR= learning_rate, N_L=20, max_width=width)
        output_state, opt_params, step_loss = LadderInit.fast_state_learning(target_rho=ModelPool[modelname])
        datalist.append(output_state.numpy())
        np.save(f"QSSMSimulation_NQ_{num_qubits}_model_{modelname}.npy", datalist)
