## Date: 2023/08/15

# Introduction

This readme gives a short description of all the PQ-QSSM simulation codes.

# Version
- Python: 3.8(.13)
- PaddleQuantum: 2.2.2
- PaddlePaddle: 2.3.2
- All other libs: current used versions

# Requirement
To run the following code successfully, please visit the following links for a setup of python environment: https://qml.baidu.com/

Currently the latest version of PaddleQuantum is 2.4.0 which might raise errors when running the codes. Please try to fix the version to 2.3.2 if that happen.

# Directory & Access

The directory has 6 .py files, including the QSSM algorithm codes and the test codes. Here
we give a brief description of each of these files for a quick ready-to-hand.

To run the codes, please firstly finish the setup by following the requirement section. Then for QSSM experiment, run

```shell
python QSSMSimulation.py
```

You can change the hyper-parameters in the `QSSMSimulation.py` file in order to change the target states, learning rate, adaptive method and etc. The training data will be stored under the same directory. Similarly for the Global QNN experiment, do

```shell
python GlobalQNNSimulation.py
```

# Content

The directory has 6 .py files, including the QSSM algorithm codes and the test codes. Here
we give a briefing on each of these files for a quick ready-to-hand:

`AdaptiveLayer.py`

The fundamental logic of constructing and executing each QSSM learning layer. Can modify to
create learning layers with different ansatzes and circuit parameters.

`QuantumLadder.py`

The main logic of establish the entire QSL learning algorithm based on the AdaptiveLayer class.
Can restrict the QSSM between truncated and non-truncated version. Initialize a QuantumLadder
object to start a learning process on a target state.

`LadderExtension.py`

The toolbox for the state learning numerical simulations. The ModelPool can be used to pre-store
the information of state data for large scaled experiments.

`QSSMSimulation.py`

The numerical test file for learning a 10-, 12- qubit GHZ state and other `StateData` states via QSSM method. Here we provide a truncated-
-learning task with different maximum widths of layer widths (2-4).

`GlobalQNNSimulation.py`

The numerical test file for learning a 10-, 12- qubit GHZ state and other `StateData` states via Global QNN method.
