from typing import Tuple, List
import numpy as np
import argparse
import sys


def lossdata_processing(*filenames: str) -> List[Tuple[np.ndarray]]:
    # extract data
    cache = {1: [], 2: [], 3: [], 4: []}
    for fname in filenames:
        with open(fname, "r") as fhandler:
            txtdata = fhandler.readlines()
        for i in range(1, 5):
            cache[i].append(np.fromstring(txtdata[i], sep=" "))

    # align the loss path
    processed_data = []
    for i in range(1, 5):
        max_path_len = max(map(len, cache[i]))
        step_losspathes = np.vstack(list(map(lambda x: np.pad(x, (0, max_path_len-len(x)), mode="edge"), cache[i])))
        step_losspath_mean = np.mean(step_losspathes, axis=0)
        step_losspath_std = np.std(step_losspathes, axis=0)
        processed_data.append((step_losspath_mean, step_losspath_std))
    return processed_data


def main(args):
    fnames = [name.strip("\n") for name in args.files]
    data_series = lossdata_processing(*fnames)
    for data in data_series:
        np.savetxt(sys.stdout, data, fmt="%.5f")


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="loss data convert to numpy array")
    parser.add_argument("files", nargs="?", type=argparse.FileType("r"), default=sys.stdin, help="A list of loss files from which we extract data")
    main(parser.parse_args())

