from typing import Optional
import numpy as np
import QCompute as qc
from project_qsl.circuit import QCircuit

__all__ = ["HardwareEfficientCircuit"]


class HardwareEfficientCircuit(QCircuit):
    def __init__(
        self,
        num_qubits: int,
        num_layers: int,
        params: Optional[np.ndarray] = None,
        backend: qc.BackendName = qc.BackendName.LocalBaiduSim2
    ) -> None:
        super().__init__(num_qubits, backend)

        if params is None:
            params = 2*np.pi*np.random.rand(num_qubits*num_layers)

        for i in range(num_layers - 1):
            for j in range(num_qubits):
                self.ry(j, params[num_qubits*i + j])
            for j, k in zip(range(num_qubits - 1), range(1, num_qubits)):
                self.cx(j, k)
        for j in range(num_qubits):
            self.ry(j, params[-(num_qubits - j)])
