import pytest
import math
from circuit import QCircuit
from hamiltonian import QHamiltonian


class TestMeasure:
    def test_single_q_measure(self):
        nshots = 4096

        cir = QCircuit(1)
        cir.h(0)
        h = QHamiltonian([(1.0, "X")])
        val = cir.expectval(h, nshots)
        math.isclose(val, 1.0, abs_tol=1e-5)

        cir = QCircuit(1)
        cir.h(0)
        cir.sdg(0)
        h = QHamiltonian([(1.0, "Y")])
        val = cir.expectval(h, nshots)
        math.isclose(val, -1.0, abs_tol=1e-5)

        cir = QCircuit(1)
        cir.x(0)
        h = QHamiltonian([(1.0, "Y")])
        val = cir.expectval(h, nshots)
        math.isclose(val, 0.0, abs_tol=1e-5)

    def test_multi_q_measure(self):
        nshots = 4096

        # GHZ state
        cir = QCircuit(3)
        cir.h(0)
        cir.cx(0, 1)
        cir.cx(0, 2)
        h = QHamiltonian([(1.0, "ZIZ"), (1.0, "XXI")])
        val = cir.expectval(h, nshots)
        math.isclose(val, 1.0, abs_tol=1e-5)

        # Bell state
        cir = QCircuit(2)
        cir.h(0)
        cir.x(1)
        cir.cx(0, 1)
        h = QHamiltonian([(-0.5, "YY"), (0.23, "XX")])
        val = cir.expectval(h, nshots)
        math.isclose(val, -0.27, abs_tol=1e-5)
