import pytest
import numpy as np
import QCompute
from hea_circuit import HardwareEfficientCircuit
from hamiltonian import QHamiltonian
from gradient import paramshift_grad
np.random.seed(12334)
QCompute.Define.Settings.outputInfo = False


H = QHamiltonian(
    [
        (-0.18121046201519708, "YY"),
        (0.3948443633559041, "ZI"),
        (0.011246157150821168, "ZZ"),
        (0.3948443633559041, "IZ")
    ]
)


def expval_fn(cir) -> float:
    return cir.expectval(H, 8192)


def test_grad():
    cir = HardwareEfficientCircuit(2, 2)
    g = paramshift_grad(cir, expval_fn)
    ans = np.asarray([-0.00818219, -0.16525263, -0.28523982, -0.16525264])
    np.testing.assert_array_almost_equal(g, ans, 2)

