TASK_NAME=rte
MODEL=distilbert-base-uncased
# Prefix that tree of saved models will be saved to
SAVE_PREFIX=/Some/path/here

DEVICE=0
BATCH_SIZES=("32")
LEARNING_RATES=("3e-5")

for LEARNING_RATE in ${LEARNING_RATES[*]}
do
    for BATCH_SIZE in ${BATCH_SIZES[*]}
    do
        CUDA_VISIBLE_DEVICES=$DEVICE python ../run_glue_admm.py \
            --task_name $TASK_NAME \
            --model_name_or_path $MODEL \
            --do_train \
            --do_eval \
            --evaluation_strategy epoch \
            --per_device_eval_batch_size=128   \
            --per_device_train_batch_size=$BATCH_SIZE   \
            --gradient_accumulation_steps=1 \
            --learning_rate $LEARNING_RATE \
            --num_train_epochs 5.0 \
            --save_steps 30000 \
            --logging_steps 1000 \
            --output_dir $SAVE_PREFIX/$TASK_NAME/$MODEL/$LEARNING_RATE/$BATCH_SIZE
    done
done
