"""
Utilities file to keep track of types of ADMM optimizers we have available
and minor integration utilities.
"""

import argparse
import enum

from .unstructured_admm import UnstructuredADMM
from .nxm_admm import NxMADMM

UNSTRUCTURED_NAME = "UNSTRUCTURED"
NxM_NAME = "NxM"

ADMM_DICT = {
    UNSTRUCTURED_NAME: UnstructuredADMM,
    NxM_NAME: NxMADMM
}

ADMM_TYPE_ENUM = enum.Enum("ADMM_TYPE_ENUM", ADMM_DICT)

def add_admm_arguments_to_parser(parser: argparse.ArgumentParser):
    """
    Quick utility to automate adding the most used arguments for ADMM-DS.
    """
    parser.add_argument("--admm_config", required=True,
                        help="Path to json config file for ADMM")
    parser.add_argument("--rho", type=float, default=1e-3,
                        help="Rho for regularizer for ADMM training")
    parser.add_argument("--admm_type", default=UNSTRUCTURED_NAME, choices=ADMM_DICT.keys(),
                        help="Type of ADMM experiment to run")
