MODEL=bert-base-uncased
TASK_NAME=mnli
DEVICE=0
# Prefix that tree of saved models will be saved to
SAVE_PREFIX=/Some/path/here

# Training hyperparameters may be specified as a list of options
LEARNING_RATES=("5e-5") 
ADMM_RHOS=("4e-4" "1e-3")
BATCH_SIZES=("32")
ADMM_TYPE=NxM

for LEARNING_RATE in ${LEARNING_RATES[*]}
do
    for BATCH_SIZE in ${BATCH_SIZES[*]}
    do    
        for BEGIN_EPOCH in ${BEGIN_EPOCHS[*]}
        do
            CUDA_VISIBLE_DEVICES=$DEVICE python ../run_glue_admm.py \
                --task_name $TASK_NAME \
                --model_name_or_path $MODEL \
                --do_train \
                --do_eval \
                --per_device_eval_batch_size=128  \
                --per_device_train_batch_size=$BATCH_SIZE   \
                --gradient_accumulation_steps=1 \
                --learning_rate $LEARNING_RATE \
                --num_train_epochs 5.0 \
                --save_steps 100000 \
                --logging_steps 2000 \
                --do_admm \
                --do_masked_finetune \
                --admm_config ./configs/bert_0_5_config.json \
                --admm_type $ADMM_TYPE \
                --overwrite_output_dir \
                --output_dir $SAVE_PREFIX/masked/$TASK_NAME/$ADMM_TYPE/$LEARNING_RATE/$BATCH_SIZE/
        done
    done
done