import os
import json
import shutil

# 配置
json_path = "results_all.json"  # 替换为你的 json 文件路径
target_root = "images"  # 新图像文件夹的根目录
dataset_root = "Datasets"  # 原始图像路径的共同根路径（用于构造相对路径）

# 创建输出目录
os.makedirs(target_root, exist_ok=True)

# 读取 JSON
with open(json_path, "r", encoding="utf-8") as f:
    data = json.load(f)

# 处理每个样本
for item in data["data"]:
    for key in ["origin_data", "extend_data_1"]:
        if key not in item:
            continue
        img_field = item[key]["image"]
        # 如果是多个图像（字符串形式的 list），解析为列表
        if isinstance(img_field, str) and img_field.strip().startswith("["):
            try:
                image_list = json.loads(img_field.replace("'", '"'))  # 转换成合法 JSON
            except:
                print(f"❌ 无法解析图像列表：{img_field}")
                continue  # 无法解析则跳过
        else:
            image_list = [img_field]
        rel_paths = []
        for img_path in image_list:
            if not os.path.exists(img_path):
                print(f"❌ 图像不存在：{img_path}")
                continue
            # 生成相对路径（相对 Datasets）
            rel_path = os.path.relpath(img_path, dataset_root)

            # 拼接 images 前缀用于 JSON 路径和复制目标
            rel_path = os.path.join("images", rel_path)
            rel_paths.append(rel_path)
            # 构造目标路径
            target_path = os.path.join(target_root, rel_path)
            os.makedirs(os.path.dirname(target_path), exist_ok=True)
            shutil.copy(img_path, target_path)
        # 更新字段
        item[key]["image"] = rel_paths if len(rel_paths) > 1 else rel_paths[0]
        item[key]["image_count"] = len(rel_paths)
# 保存修改后的 JSON
with open("results_all_new.json", "w", encoding="utf-8") as f:
    json.dump(data, f, ensure_ascii=False, indent=4)

print("✅ 处理完成，图像已复制，JSON 已更新")
