
# Image Editing Pipeline

This tool implements a two-step pipeline for semantic image editing, leveraging **LISA (segmentation)** and **KVEDIT (editing)** to generate augmented datasets. Below is a concise overview of the pipeline and how to run it.


## Pipeline Overview  
```mermaid  
graph LR  
    A[Input Image] --> B[LISA: Segment Target Object]  
    B --> C[KVEDIT: Replace/Remove Segmented Object]  
    C --> D[Output Augmented Image]  
```  

1. **LISA (Local Image Segmentation API)**  
   - Uses text prompts (e.g., "segment the red car") to generate object masks.  
   - Output: Binary mask file (.png) indicating the region to edit.  

2. **KVEDIT (Local Image Editing API)**  
   - Takes the original image, mask, and text prompts (source/target descriptions).  
   - For **replacement**: Replaces the segmented object (e.g., change "red car" to "blue truck").  
   - For **removal**: Removes the segmented object and fills the background.  


## How to Run the Pipeline  

### Step 1: Start Local Services  
1. **Launch LISA (segmentation service)**  
   ```bash  
   python LISA-main/pipline.py --port 8001  
   ```  
   - Listens on `http://localhost:8001/process` for segmentation requests.  

2. **Launch KVEDIT (editing service)**  
   ```bash  
   python KV-Edit-main/pipline.py --port 5000  
   ```  
   - Listens on `http://localhost:5000/edit_image` for editing requests.  


### Step 2: Prepare Input Data  
Create a JSON file (e.g., `input.json`) with:  
- `image_path`: Path to the original image.  
- `edit_type`: `replace` or `remove` (decided by your strategy).  
- `prompts`:  
  - `segment_prompt`: Text to describe the object to segment (e.g., "segment the green apple").  
  - `source_prompt`: Description of the original scene (for context).  
  - `target_prompt`: Description of the desired edit (e.g., "a group of red apples").  

**Example Input:**  
```json  
{  
  "image_path": "data/original.jpg",  
  "edit_type": "replace",  
  "prompts": {  
    "segment_prompt": "segment the green apple",  
    "source_prompt": "a bowl of red apples with one green apple",  
    "target_prompt": "a bowl of red apples with one orange"  
  }  
}  
```  


### Step 3: Execute the Pipeline  
Use the provided Python script to run the pipeline

